#ifndef ADC_H_
#define ADC_H_

//ADתʽѡλ							-------ADCCTL0
#define		ADC_DIR_Left					0x00
#define		ADC_DIR_Right					0x80
//ADʱѡλ
#define		ADC_SEL_SCLK					0x00
#define		ADC_SEL_HFCLK					0x04
#define		ADC_SEL_LFCLK					0x08
//ADرλ
#define		ADC_enable()			ADCCTL0|=0x01
#define		ADC_disable()   		ADCCTL0&=0xfe

//ADʧУ׼ʹλ								-------ADCCTL1
#define		ADC_calibration_enable			0x80
#define		ADC_calibration_disable			0x00
//ADתʱѡλ
#define 	ADC_FAD_SCLKDIV2				(0x00)	/*!< 0B0000 0000 	SCLK/2*/
#define 	ADC_FAD_SCLKDIV8				(0x10)	/*!< 0B0001 0000 	SCLK/8*/
#define 	ADC_FAD_SCLKDIV32				(0x20)	/*!< 0B0010 0000 	SCLK/32*/
#define 	ADC_FAD_500K	 				(0x30)	/*!< 0B0011 0000 	500KHz*/
#define 	ADC_FAD_SCLKDIV4	 			(0x40)	/*!< 0B0100 0000 	SCLK/4*/
#define 	ADC_FAD_SCLKDIV16	 			(0x50)	/*!< 0B0101 0000 	SCLK/16*/
#define 	ADC_FAD_SCLKDIV64				(0x60)	/*!< 0B0110 0000 	SCLK/64*/
//ADתοѹѡλ
#define 	ADC_VREF_OFF					(0x00)	/*!< 0B0000 0000 */
#define 	ADC_VREF_VDD 					(0x04)	/*!< 0B0000 0100 */
#define 	ADC_VREF_VREFIN					(0x08)	/*!< 0B0000 1000 */
#define 	ADC_VREF_VREFOUT 				(0x0C)	/*!< 0B0000 1100 */

//ADʧУ׼ʹλ								-------ADCCTL1
/*ADCCTL2  :ADCHS<6:0>--------------------------------------------------------*/
#define 	AN0 						(0x00)    /*!<  P43/AD0 */
#define 	AN1 						(0x01)    /*!<  P44/AD1*/
#define 	AN2 						(0x02)    /*!<  P45/AD2*/
#define 	AN3 						(0x03)    /*!<  P30/AD3*/
#define 	AN4 						(0x04)    /*!<  P31/AD4*/
#define 	AN5 						(0x05)    /*!<  P32/AD5*/
#define 	AN6 						(0x06)    /*!<  P33/AD6*/
#define 	AN7 						(0x07)    /*!<  P07/AD7*/
#define 	AN8 						(0x08)	  /*!<  P06/AD8*/
#define 	AN9 						(0x09)	  /*!<  P75/AD9*/
#define 	AN10 						(0x0A)	  /*!<  PA2/AD10*/
#define 	AN11 						(0x0B)	  /*!<  P05/AD11*/
#define 	AN12 						(0x0C)	  /*!<  P04/AD12*/
#define 	AN13 						(0x0D)	  /*!<  P03/AD13*/
#define 	AN14 						(0x0E)	  /*!<  P02/AD14*/
#define 	AN15 						(0x0F)	  /*!<  P01/AD15*/
#define 	AN16 						(0x10)	  /*!<  P74/AD16*/
#define 	AN17 						(0x11)	  /*!<  P73/AD17*/
#define 	AN18 						(0x12)	  /*!<  PA1/AD18*/
#define 	AN19 						(0x13)    /*!<  PA0/AD19*/
#define 	AN20 						(0x14)    /*!<  P13/AD20*/
#define 	AN21 						(0x15)    /*!<  P12/AD21*/
#define 	AN22 						(0x16)    /*!<  P10/AD22*/
#define 	AN23 						(0x17)    /*!<  P23/AD23*/
#define 	AN24 						(0x18)    /*!<  P24/AD24*/
#define 	AN25 						(0x19)	  /*!<  P25/AD25*/
#define 	AN26 						(0x1A)    /*!<  P50/AD26*/
#define 	AN27 						(0x1B)    /*!<  P51/AD27*/
#define 	AN28 						(0x1C)    /*!<  P52/AD28*/
#define 	AN29 						(0x1D)    /*!<  P53/AD29*/
#define 	AN30 						(0x1E)	  /*!<  P54/AD30*/
#define 	AN31 						(0x1F)    /*!<  P55/AD31*/
#define 	AN32 						(0x20)    /*!<  P61/AD32*/
#define 	AN33 						(0x21)    /*!<  P62/AD33*/
#define 	AN34 						(0x22)    /*!<  P63/AD34*/
#define 	AN35 						(0x23)    /*!<  P64/AD35*/
#define 	AN36 						(0x24)	  /*!<  P65/AD36*/
#define 	AN37 						(0x25)    /*!<  P66/AD37*/
#define 	AN38 						(0x26)    /*!<  P95/AD38*/
#define 	AN39 						(0x27)    /*!<  P94/AD39*/
#define 	AN40 						(0x28)    /*!<  P93/AD40*/
#define 	AN41 						(0x29)	  /*!<  P92/AD41*/
#define 	AN42 						(0x2A)    /*!<  P91/AD42*/
#define 	AN43 						(0x2B)    /*!<  P90/AD43*/


#define 	AN44 						(0x2C)    /*!< TS_OUT  */
#define 	AN45 						(0x2D)    /*!< VRE_OUT */

/*ADCINTCTL  :INTCTL<1:0>--------------------------------------------------------*/
#define 		ADC_InterruptMode_1Conv		(0x00)	/*!< 0B0000 0000 */
#define 		ADC_InterruptMode_2Conv		(0x01)	/*!< 0B0000 0001 */
#define 		ADC_InterruptMode_3Conv		(0x02)	/*!< 0B0000 0010 */
#define 		ADC_InterruptMode_4Conv		(0x03)	/*!< 0B0000 0011 */



/*ADC Functions--------------------------------------------------------*/

void 			ADC_Configuration(void);
unsigned int  	ADC_GetData(void);
unsigned int 	ADC_GetConvertData(unsigned char chsel,unsigned char fitercount);


#endif
